package gov.va.genisis2.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

/**
 * Data Transfer Object (DTO) to transfer user related details
 * 
 * @author Prasad Thummalapalli
 *
 */
@XmlRootElement(name = "user")
@JsonInclude(Include.NON_NULL)
@JsonIgnoreProperties({ "inactiveDate", "activeDate", "userActive", "lastName2", "userRoleTypes", "userApproversForUserId" })
public class UserDTO implements Serializable {

	private static final long serialVersionUID = -3594701048329128323L;

	private int userId;
	private String firstName;
	private String middleName;
	private String lastName;
	private String lastName2;
	private Date createDate;
	private String emailId;
	private String status;
	private byte userActive;
	private Date activeDate;
	private Date inactiveDate;
	private Set<UserRoleTypeDTO> userRoleTypes;
	private Set<UserApproverDTO> userApproversForUserId;
	private String role;
	private String roleDesc;
	private String approver;
	private String username;

	/**
	 * @return the userId
	 */
	public int getUserId() {
		return userId;
	}

	/**
	 * @param userId
	 *            the userId to set
	 */
	public void setUserId(int userId) {
		this.userId = userId;
	}

	/**
	 * @return the firstName
	 */
	public String getFirstName() {
		return firstName;
	}

	/**
	 * @param firstName
	 *            the firstName to set
	 */
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	/**
	 * @return the middleName
	 */
	public String getMiddleName() {
		return middleName;
	}

	/**
	 * @param middleName
	 *            the middleName to set
	 */
	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	/**
	 * @return the lastName
	 */
	public String getLastName() {
		return lastName;
	}

	/**
	 * @param lastName
	 *            the lastName to set
	 */
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	/**
	 * @return the lastName2
	 */
	public String getLastName2() {
		return lastName2;
	}

	/**
	 * @param lastName2
	 *            the lastName2 to set
	 */
	public void setLastName2(String lastName2) {
		this.lastName2 = lastName2;
	}

	/**
	 * @return the createDate
	 */
	public Date getCreateDate() {
		return createDate;
	}

	/**
	 * @param createDate
	 *            the createDate to set
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	/**
	 * @return the emailId
	 */
	public String getEmailId() {
		return emailId;
	}

	/**
	 * @param emailId
	 *            the emailId to set
	 */
	public void setEmailId(String emailId) {
		this.emailId = emailId;
	}

	/**
	 * @return the userActive
	 */
	public byte getUserActive() {
		return userActive;
	}

	/**
	 * @param userActive
	 *            the userActive to set
	 */
	public void setUserActive(byte userActive) {
		this.userActive = userActive;
	}

	/**
	 * @return the activeDate
	 */
	public Date getActiveDate() {
		return activeDate;
	}

	/**
	 * @param activeDate
	 *            the activeDate to set
	 */
	public void setActiveDate(Date activeDate) {
		this.activeDate = activeDate;
	}

	/**
	 * @return the inactiveDate
	 */
	public Date getInactiveDate() {
		return inactiveDate;
	}

	/**
	 * @param inactiveDate
	 *            the inactiveDate to set
	 */
	public void setInactiveDate(Date inactiveDate) {
		this.inactiveDate = inactiveDate;
	}

	/**
	 * @return the userRoleTypes
	 */
	public Set<UserRoleTypeDTO> getUserRoleTypes() {
		return userRoleTypes;
	}

	/**
	 * @param userRoleTypes
	 *            the userRoleTypes to set
	 */
	public void setUserRoleTypes(Set<UserRoleTypeDTO> userRoleTypes) {
		this.userRoleTypes = userRoleTypes;
	}

	/**
	 * @return the userApproversForUserId
	 */
	public Set<UserApproverDTO> getUserApproversForUserId() {
		return userApproversForUserId;
	}

	/**
	 * @param userApproversForUserId
	 *            the userApproversForUserId to set
	 */
	public void setUserApproversForUserId(Set<UserApproverDTO> userApproversForUserId) {
		this.userApproversForUserId = userApproversForUserId;
	}

	/**
	 * @return the role
	 */
	public String getRole() {
		return role;
	}

	/**
	 * @param role
	 *            the role to set
	 */
	public void setRole(String role) {
		this.role = role;
	}
	
	/**
	 * @return the roleDesc
	 */
	public String getRoleDesc() {
		return roleDesc;
	}
	
	/**
	 * @param roleDesc
	 *            the roleDesc to set
	 */
	public void setRoleDesc(String roleDesc) {
		this.roleDesc = roleDesc;
	}

	/**
	 * @return the approver
	 */
	public String getApprover() {
		return approver;
	}

	/**
	 * @param approver
	 *            the approver to set
	 */
	public void setApprover(String approver) {
		this.approver = approver;
	}
	
	/**
	 * @return username the user name
	 */
	public String getUsername() {
		return username;
	}
	
	/**
	 * @param username the user name
	 */
	public void setUsername(String username) {
		this.username = username;
	}

	/**
	 * @return the status
	 */
	public String getStatus() {
		return status;
	}

	/**
	 * @param status the status to set
	 */
	public void setStatus(String status) {
		this.status = status;
	}
}
